<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Tracing\Interfaces\SpanStatus;

trait Status {
    /**
     * @var string
     */
    protected string $statusCode;

    /**
     * @var string
     */
    protected string $statusMessage;

    /**
     * @return string
     */
    public function getStatusCode (): string {
        return $this->statusCode;
    }

    /**
     * @return string
     */
    public function getStatusMessage (): string {
        return $this->statusMessage;
    }

    /**
     * @return $this
     */
    public function statusOk (): self {
        $this->statusCode = SpanStatus::OK;
        return $this->setStatusMessage();
    }

    /**
     * @return $this
     */
    public function statusError (string $errorMsg = ''): self {
        $this->statusCode = SpanStatus::ERROR;
        $this->statusMessage = $errorMsg ?: SpanStatus::DESCRIPTION[SpanStatus::ERROR];
        return $this;
    }

    /**
     * @return $this
     */
    public function statusUnset (): self {
        $this->statusCode = SpanStatus::UNSET;
        return $this->setStatusMessage();
    }

    /**
     * @return $this
     */
    private function setStatusMessage (): self {
        $this->statusMessage = SpanStatus::DESCRIPTION[$this->statusCode] ?? '';
        return $this;
    }
}
