<?php


namespace Mainto\RpcServer\RpcServer;


use Mainto\RpcServer\Util\Language;

abstract class RpcObject implements \JsonSerializable {
    /**
     * @return array|object
     */
    public function jsonSerialize () {
        $data = [];
        $vars = get_object_public_vars($this);
        foreach (RpcDefinition::getInstance()->getStruct(static::class)->properties as $property) {
            if ($property->exists($vars)) {
                $data[$property->name] = $property->get($vars);
            }
        }
        if ($data) {
            return $data;
        }

        return Language::$placeholder;
    }
}