<?php

namespace Mainto\RpcServer\RpcUtil\Tool\RpcMutex;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;

class CoreGearMutex implements RpcMutexProviderInterface {
    private static function getLockCli (): RpcClass {
        return RpcClass::getClass("CoreGear", "Lock");
    }

    public static function getLock (string $lockName, int $expireTime = 600) {
        return static::getLockCli()->getLock([
            "lockName"   => $lockName,
            "expireTime" => $expireTime,
        ]);
    }

    public static function unLock (string $lockName, string $password): bool {
        return static::getLockCli()->unlock([
            "lockName" => $lockName,
            "password" => $password,
        ]);
    }
}