<?php


namespace Mainto\RpcServer\RpcUtil\Tool;


interface RpcLogInterface {
    /**
     * log info message
     *
     * @param string $title
     * @param $message
     */
    public function info (string $title, $message);

    /**
     * log debug message
     *
     * @param string $title
     * @param $message
     */
    public function debug (string $title, $message);

    /**
     * log notice message
     *
     * @param string $title
     * @param $message
     */
    public function notice (string $title, $message);

    /**
     * log warning message
     *
     * @param string $title
     * @param $message
     */
    public function warning (string $title, $message);

    /**
     * log error message
     *
     * @param string $title
     * @param $message
     */
    public function error (string $title, $message);

    /**
     * log critical message
     *
     * @param string $title
     * @param $message
     */
    public function critical (string $title, $message);
}