<?php

namespace Mainto\RpcServer\Tracing\Support\Zipkin;

use GuzzleHttp\Client;
use Mainto\RpcServer\Tracing\Interfaces;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Tracing\Source;
use Psr\Http\Client\ClientInterface;
use Throwable;

class Exporter implements Interfaces\ExporterInterface {
    /**
     * @var string
     */
    private string $uri = 'http://127.0.0.1:9411/api/v2/spans';


    /**
     * @var Client
     */
    private ClientInterface $client;

    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct () {
        $this->converter = new Converter();
        $this->client = new Client([
            'timeout' => 1,
        ]);
    }

    /**
     * @param array $spans
     * @param Source $source
     */
    public function export (iterable $spans, Source $source): void {
        // 默认值
        $convertSpans = $this->converter->converts($spans, $source);

        try {
            // 提交
            $this->client->requestAsync('POST', $this->uri, [
                'json' => $convertSpans,
            ]);
        } catch (Throwable $e) {
            Log::error('tracing upload fail: '.$e->getMessage());
        }
    }
}
