<?php

namespace Mainto\RpcServer\Tracing\Support\Aliyun;

use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Source;
use Mainto\RpcServer\Tracing\Span;

class Converter {

    /**
     * @param iterable $spans
     * @param Source $source
     * @return array
     */
    public function convert (iterable $spans, Source $source): array {
        // 默认值
        $convertedSpans = [];
        // 遍历循环spans
        foreach ($spans as $span) {
            // 转换
            $convertedSpans[] = $this->convertSpan($span, $source);
        }
        // convertedSpan
        return $convertedSpans;
    }

    /**
     * @param Span $span
     * @param Source $source
     * @return array
     */
    public function convertSpan (Span $span, Source $source): array {
        $row = [
            'host'          => $source->getHost(),
            'service'       => $source->getServiceName(),
            'otlp.name'     => $source->getSdkVersion()->getName(),
            'otlp.version'  => $source->getSdkVersion()->getVersion(),
            'name'          => $span->getName(),
            'kind'          => SpanKind::TYPES[$span->getKind()] ?? 'server',
            'traceID'       => $span->getTraceId(),
            'spanID'        => $span->getSpanId(),
            'parentSpanID'  => $span->getParentId(),
            'start'         => $span->getStartEpochNanos(),
            'end'           => $span->getEndEpochNanos(),
            'duration'      => $span->getDuration(),
            'statusCode'    => $span->getStatusCode(),
            'statusMessage' => $span->getStatusMessage(),
            'resource'      => $source->getResources(),
            $this->convertResource($span->getResource()),
        ];
        // 合并数组
        $row['attribute'] = $span->getAttributes()->merge($source->getAttributes());
        // 判断是否为空
        if (!empty($span->getEvents())) {
            // 初始化
            $row['logs'] = [];
            // 遍历循环
            foreach ($span->getEvents() as $event) {
                // 追加数据
                $row['logs'][] = [
                    'name'       => $event->getName(),
                    'timestamp'  => $event->getTimestamp(),
                    'attributes' => $event->getAttributes(),
                ];
            }
        }
        // 返回
        return $row;
    }
}
