<?php

namespace Mainto\RpcServer\Tracing;

use OpenTelemetry\API\Trace\SpanContextValidator;

class SpanContext {
    /**
     * @var string
     */
    private string $traceId = '';

    /**
     * @var string
     */
    private string $spanId = '';

    /**
     * @var string
     */
    private string $parentSpanId = '';

    private bool $isValid = true;

    /**
     * @var Span|null
     */
    private ?Span $span;

    /**
     * @param string $traceId
     * @param string $spanId
     * @param string $parentSpanId
     * @param Span|null $span
     */
    public function __construct (string $traceId, string $spanId, string $parentSpanId = '', Span $span = null) {
//        if (!SpanContextValidator::isValidTraceId($traceId) || !SpanContextValidator::isValidSpanId($spanId)) {
//            $traceId = SpanContextValidator::INVALID_TRACE;
//            $spanId = SpanContextValidator::INVALID_SPAN;
//            $this->isValid=false;
//        }


        $this->traceId = $traceId;
        $this->spanId = $spanId;
        $this->parentSpanId = $parentSpanId;
        $this->span = $span;
    }

    /**
     * @return string
     */
    public function getTraceId (): string {
        return $this->traceId;
    }

    /**
     * @return string
     */
    public function getTraceIdBinary(): string
    {
        return hex2bin($this->traceId);
    }

    /**
     * @return bool
     */
    public function hasTraceId (): bool {
        return !empty($this->traceId);
    }

    /**
     * @return string
     */
    public function getSpanId (): string {
        return $this->spanId;
    }

    public function getSpanIdBinary(): string
    {
        return hex2bin($this->spanId);
    }

    /**
     * @return bool
     */
    public function hasSpanId (): bool {
        return !empty($this->spanId);
    }

    /**
     * @return string
     */
    public function getParentSpanId (): string {
        return $this->parentSpanId;
    }

    /**
     * @return bool
     */
    public function hasParentSpanId (): bool {
        return !empty($this->parentSpanId);
    }

    /**
     * @return Span|null
     */
    public function getSpan (): ?Span {
        return $this->span;
    }

    public function isValid(): bool
    {
        return $this->isValid;
    }

    /**
     * 清空span
     */
    public function clearSpan (): void {
        $this->span = null;
    }

    /**
     * @return SpanContext
     */
    public static function emptyContext (): SpanContext {
        return new SpanContext('', '');
    }
}