<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Traits\Attributes;
use Mainto\RpcServer\Util\Types\Map;

class Event {
    use Attributes;

    /**
     * @var string
     */
    private string $name;

    /**
     * @var float
     */
    private float $timestamp;

    /**
     * @param string $name
     * @param int $timestamp
     * @param Map|null $attributes
     */
    public function __construct (string $name, int $timestamp, ?Map $attributes = null) {
        $this->name = $name;
        $this->timestamp = $timestamp ?: \time();
        $this->attributes = $attributes ?: new Map();
    }

    /**
     * @return string
     */
    public function getName (): string {
        return $this->name;
    }


    public function getEpochNanos(): int
    {
        return $this->timestamp;
    }

    /**
     * @return float
     */
    public function getTimestamp (): float {
        return $this->timestamp;
    }
}
