<?php


namespace Mainto\RpcServer\RpcAnnotations;

use Doctrine\Common\Annotations\Annotation\Attribute;
use Doctrine\Common\Annotations\Annotation\Attributes;

/**
 * Class RpcDeprecated
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"ALL"})
 *
 * @Attributes({
 *     @Attribute("since", type="string"),
 *     @Attribute("reason", type="string"),
 *     @Attribute("replacement",type="string"),
 * })
 */
class RpcDeprecated {
    /**
     * 何时废弃
     *
     * @var string
     */
    public string $since = "";

    /**
     * 废弃原因
     * @Required
     * @var string
     */
    public string $reason = "";


    /**
     * 废弃替代方案
     * @var string
     */
    public string $replacement = "";

}