<?php


namespace Mainto\RpcServer\RpcClient;


use Mainto\RpcServer\Util\Net\Exceptions\ServerNotFoundException;
use RuntimeException;

class RpcClientFactory {
    public const RpcClassClient = 'getRpcClassClient';
    public const SlsClient = 'getSlsClient';
    public const MessageClient = 'getMessageClient';
    public const MonitorClient = 'getMonitorClient';
    public const SettingClient = 'getSettingClient';

    public static function getClient($key, ...$args) {
        return call_user_func_array([__class__, $key], ...$args);
    }

    /**
     * @var array
     */
    public static array $clients = [];

    public static function getRpcClassClient (string $serviceName): RpcClient {
        try {
            $key = "rpc-class-".$serviceName;
            if (!isset(self::$clients[$key])) {
                self::$clients[$key] = RpcClient::getServiceClient($serviceName);
            }

            return self::$clients[$key];
        } catch (ServerNotFoundException $exception) {
            throw new RuntimeException("can not find server {$serviceName}");
        }
    }

    public static function clearRpcClassClient (string $serviceName) {
        $key = "rpc-class-".$serviceName;
        if (isset(self::$clients[$key])) {
            /** @var RpcClient $client */
            $client = self::$clients[$key];
            unset(self::$clients[$key]);
            $client->close();
        }
    }

    public static function getSlsClient (): RpcClient {
        try {
            $key = "sls";
            if (!isset(self::$clients[$key])) {
                self::$clients[$key] = RpcClient::getSLSClient();
            }

            return self::$clients[$key];
        } catch (ServerNotFoundException $exception) {
            throw new RuntimeException("can not find server sls");
        }
    }

    public static function getMessageClient (): RpcClient {
        try {
            $key = "message";
            if (!isset(self::$clients[$key])) {
                self::$clients[$key] = RpcClient::getMessageClient();
            }

            return self::$clients[$key];
        } catch (ServerNotFoundException $exception) {
            throw new RuntimeException("can not find server message");
        }
    }

    public static function getMonitorClient (): RpcClient {
        try {
            $key = "monitor";
            if (!isset(self::$clients[$key])) {
                self::$clients[$key] = RpcClient::getMonitorClient();
            }

            return self::$clients[$key];
        } catch (ServerNotFoundException $exception) {
            throw new RuntimeException("can not find server monitor");
        }
    }

    public static function getSettingClient (): RpcClient {
        try {
            $key = "setting";
            if (!isset(self::$clients[$key])) {
                self::$clients[$key] = RpcClient::getSettingClient();
            }

            return self::$clients[$key];
        } catch (ServerNotFoundException $exception) {
            throw new RuntimeException("can not find server setting");
        }
    }

    public static function clearAllClient () {
        /** @var RpcClient $client */
        foreach (self::$clients as $key => $client) {
            unset(self::$clients[$key]);
            $client->close();
        }
    }

    public static function getClients (): array {
        return self::$clients;
    }

    public static function clearClient ($rpcClient) {
        /** @var RpcClient $client */
        foreach (self::$clients as $key => $client) {
            if ($client == $rpcClient) {
                unset(self::$clients[$key]);
                $client->close();
            }
        }
    }
}
