<?php

namespace Mainto\RpcServer\Tracing\Support\OTEL;

use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Tracing\Interfaces;
use Mainto\RpcServer\Tracing\Source;
use OpenTelemetry\Contrib\Otlp\ProtobufSerializer;
use OpenTelemetry\SDK\Common\Export\TransportInterface;
use RuntimeException;
use Throwable;

/**
 * 上报器
 */
class Exporter implements Interfaces\Exporter {

    private TransportInterface $transport;
    private ProtobufSerializer $serializer;

    /**
     * 实例化
     */
    public function __construct (TransportInterface $transport) {
        if (!class_exists('\Google\Protobuf\Api')) {
            throw new RuntimeException('No protobuf implementation found (ext-protobuf or google/protobuf)');
        }
        $this->transport = $transport;
        $this->serializer = ProtobufSerializer::forTransport($transport);
    }

    /**
     * @param iterable $spans
     * @param Source $source
     * @return void
     */
    public function export (iterable $spans, Source $source): void {
        try {
            $this->transport->send($this->serializer->serialize((new Converter($this->serializer))->convert($spans)), null);
        } catch (Throwable $throwable) {
            Log::info('Export failure', ['exception' => $throwable]);
            return;
        }
    }
}
