<?php

namespace Mainto\RpcServer\RpcServer\Middleware\Method;

use Closure;
use Illuminate\Support\Str;
use Mainto\RpcServer\RpcServer\Middleware\MethodMiddleware;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

class TooManyParametersCheckMiddleware implements MethodMiddleware {

    public function handle (RpcContext $context, Closure $next, $args = []) {
        if (RpcDefinition::getInstance()->structs->get($context->getMethod()->requestType)) {

            $keys = [];
            foreach (RpcDefinition::getInstance()->structs[$context->getMethod()->requestType]->properties as $property) {
                $keys[] = $property->getSerializedName();
            }

            $unnecessary = array_diff(array_keys($context->all()), $keys);
            if ($unnecessary) {
                app(RpcLog::class)::getInstance()->warning("request too many parameters", [
                    "method" => $context->getMethod()->name,
                    "class"  => $context->getController()->registerName,
                ]);
            }
        }

        return $next($context);
    }

    private static ?TooManyParametersCheckMiddleware $instance = null;

    private function __construct () {
    }

    public static function getInstance (): ?TooManyParametersCheckMiddleware {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}