<?php

namespace Mainto\RpcServer\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\Command\Sidecar\Sidecar;

class RpcSidecarCommand extends Command {
    const SidecarUrl = "https://s3.code.hzmantu.com/sidecar/php/";

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:sidecar {option?} {arg?} {--sidecar-worker-server-port=} {--hostname=} {--sidecar-etcd-server-address=} {--parse-log-filepath}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Sidecar Command';

    /**
     * 可用的 Command
     * @var array
     */
    private $commands = [
        'start',
        'config',
        'download',
        'tools',
        'version',
    ];

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    private function optionSet () {
        $config = app()['config'];
        // env for child process
        // config for gen config.local.env
        if ($sidecarServerPort = $this->option('sidecar-worker-server-port')) {
            $config->set('rpc-server.sidecar.worker.server.port', $sidecarServerPort);
            putenv('RPC_SIDECAR_WORKER_SERVER_PORT='.$sidecarServerPort);
        }

        if ($hostname = $this->option('hostname')) {
            $config->set('rpc-server.sidecar.hostname', $hostname);
            putenv('RPC_SIDECAR_HOSTNAME='.$hostname);
        }

        if ($etcd = $this->option('sidecar-etcd-server-address')) {
            $config->set('rpc-server.sidecar.etcd.server_address', $etcd);
            putenv('RPC_SIDECAR_ETCD_SERVER_ADDRESS='.$etcd);
        }
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle () {
        $command = $this->argument('option');
        $arg = $this->argument('arg');
        $this->optionSet();

        if (!$command || !in_array($command, $this->commands)) {
            $this->warn(sprintf("Usage: php artisan rpc:sidecar {%s} {worker|parse_log}", implode('|', $this->commands)));
            exit(1);
        }
        if (!$arg && (!in_array($command, ['download', 'config', 'version']))) {
            dd('Usage: php artisan rpc:sidecar {download|start|config} {worker}');
        }
        $sidecar = new Sidecar(self::SidecarUrl);

        switch ($command) {
            case "download":
                $sidecar->downloadSidecar();
                break;
            case "start":
                $sidecar->downloadSidecar();
                $sidecar->generateSidecarConfig();
                chdir(dirname($sidecar->getSidecarCommand()));
                system(sprintf("%s %s", $sidecar->getSidecarCommand(), $arg));
                break;
            case "config":
                $sidecar->generateSidecarConfig();
                break;
            case "tools":
                switch ($arg) {
                    case "parse_log":
                        $logFile = $this->option("parse-log-filepath");
                        if (!$logFile) {
                            $logFile = storage_path("logs/service/sidecar.log");
                        }
                        if (!file_exists($logFile)) {
                            $this->error("log file not found: [${logFile}]");
                            exit(1);
                        }
                        chdir(dirname($sidecar->getSidecarCommand()));
                        system(sprintf("%s %s %s", $sidecar->getSidecarCommand(), $arg, sprintf('--file="%s"', $logFile)));
                        break;
                }
                break;
            case "version":
                print $sidecar->getSidecarRuntimeVersion();
                break;
        }

        return 0;
    }
}
