<?php

namespace Mainto\RpcServer\RpcUtil\Tool\RpcMutex;

use GuzzleHttp\Client;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;
use Throwable;

class PbcComponentMutex implements RpcMutexProviderInterface {

    public static function getClient (): Client {
        return new Client([
            'base_uri' => env('PBC_COMPONENT_URL'),
            'timeout'  => 3,
        ]);
    }

    public static function query (string $path, array $query = []): array {
        try {
            $response = static::getClient()->get($path, [
                'query' => $query,
            ]);
            if ($response->getStatusCode() == 200) {
                $content = $response->getBody()->getContents();
                $result = json_decode($content, true);
                if (!empty($result)) {
                    return $result;
                }
            }
        } catch (Throwable $e) {
            RpcLog::getInstance()->debug('PbcComponentMutex.Request.Error', [
                'query' => $query,
                'error' => $e->getMessage(),
            ]);
        }
        return [];
    }

    public static function getLock (string $lockName, int $expireTime = 600) {
        $result = static::query('/pbc-component/lock/getLock', [
            'lockName'   => $lockName,
            'expireTime' => $expireTime,
        ]);
        if (empty($result) || !isset($result['success']) || $result['success'] !== true) {
            return false;
        }
        return $result['msg'];
    }

    public static function unLock (string $lockName, string $password): bool {
        $result = static::query('/pbc-component/lock/unlock', [
            'lockName' => $lockName,
            'password' => $password,
        ]);
        if (empty($result) || !isset($result['success'])) {
            return false;
        }
        return $result['success'];
    }
}