<?php

namespace Mainto\RpcServer\Tracing\Support\Aliyun;

use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;
use Mainto\RpcServer\Tracing\Interfaces;
use Mainto\RpcServer\Tracing\Source;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Tracing\SpanArray;
use Throwable;

/**
 * 上报器
 */
class Exporter implements Interfaces\ExporterInterface {
    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct () {
        $this->converter = new Converter();
    }

    /**
     * @param array|Span[] $spans
     * @param Source $source
     */
    public function export (iterable $spans, Source $source): void {
        try {
            // 转换span数据为阿里云链路格式
            $convertSpan = $this->converter->convert($spans, $source);
            RpcLog::getInstance()->tracer(new SpanArray($convertSpan));
        } catch (Throwable $e) {
            Log::error('trace exportSpan fail! error: '. $e->getMessage());
        }
    }

    /**
     * @param Span $span
     * @param Source $source
     */
    public function exportSpan (Span $span, Source $source): void {
        try {
            // 转换span数据为阿里云链路格式
            $convertSpan = $this->converter->convertSpan($span, $source);
            RpcLog::getInstance()->tracer(new SpanArray($convertSpan));
        } catch (Throwable $e) {
            Log::error('trace exportSpan fail! error: '. $e->getMessage());
        }
    }
}
