<?php


namespace Mainto\RpcServer\RpcAnnotations;


/**
 * Class RpcProperty
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"PROPERTY"})
 *
 * @Attributes({
 *     @Attribute("validation", type = "string"),
 *     @Attribute("name", type = "string"),
 *     @Attribute("comment", type = "string"),
 *     @Attribute("example", type = "string"),
 *     @Attribute("fromSession", type="string"),
 *     @Attribute("fromHeader", type="string"),
 *     @Attribute("type", type="string"),
 * })
 */
class RpcProperty {
    /**
     * @var string
     */
    public string $validation = "";

    /**
     * @var string
     */
    public string $name = "";

    /**
     * @var string
     */
    public string $comment = "";

    /**
     * @var string
     */
    public string $example = "";

    /**
     * 从 session 中获取值
     *
     * @var string
     */
    public string $fromSession = "";

    /**
     * @var string
     */
    public string $fromHeader = "";

    /**
     * 参数类型
     *
     * @Enum({
     *     "string", "bool",
     *     "int", "uint",
     *     "double", "unsignedDouble",
     *     "array", "array<int>", "array<uint>", "array<string>",
     *     "mixed"
     * })
     * @var string
     */
    public string $type = "";
}