<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Traits\Attributes;
use Mainto\RpcServer\Tracing\Traits\Resource;
use Mainto\RpcServer\Util\Types\Map;

class Source {
    use Attributes, Resource;

    /**
     * @var string
     */
    protected string $host;

    /**
     * @var string
     */
    protected string $serviceName;

    /**
     * @var SdkVersion
     */
    protected SdkVersion $sdkVersion;

    /**
     * 构造函数
     */
    public function __construct (SdkVersion $sdkVersion) {
        $this->host = gethostname() ?? 'unknown';
        $this->serviceName = config('rpc-server.service_name', 'NoName');
        $this->sdkVersion = $sdkVersion;
        $this->resource = new Map();
        $this->attributes = new Map();
    }

    /**
     * @return string
     */
    public function getHost (): string {
        return $this->host;
    }

    /**
     * @return string
     */
    public function getServiceName (): string {
        return $this->serviceName;
    }

    /**
     * @return SdkVersion
     */
    public function getSdkVersion (): SdkVersion {
        return $this->sdkVersion;
    }
}
