<?php


namespace Mainto\RpcServer\RpcServer\Middleware\Method;


use Closure;
use Mainto\RpcServer\RpcServer\Middleware\MethodMiddleware;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcServer\RpcDefinition;

class ValidateMiddleware implements MethodMiddleware {
    private static ?ValidateMiddleware $instance = null;

    private function __construct () { }

    public static function getInstance (): ?ValidateMiddleware {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function handle (RpcContext $context, Closure $next, $args = []) {
        $params = $context->getParams();
        $requestStruct = RpcDefinition::getInstance()->getStruct($context->getMethod()->requestType);

        $requestStruct->validate($params);

        $context->setParams($params);

        return $next($context);
    }
}