<?php

namespace Mainto\RpcServer\Service\Struct;

use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\RpcAnnotations\RpcException;
use Mainto\RpcServer\Util\Types\Map;

class Path implements Arrayable {
    use BaseStruct;

    /**
     * @var string|null
     */
    private ?string $httpUrl = null;

    /**
     * @var string|null
     */
    private ?string $httpMethod = null;

    /**
     * @var array
     */
    private array $headers = [];

    /**
     * @var RpcException[]
     */
    private array $exceptions = [];

    /**
     * @var Map
     */
    private Map $responseHeader;

    /**
     * @var string
     */
    private string $format = "Json";

    /**
     * @var array
     */
    private array $needAuthority = [];

    /**
     * @var string|null
     */
    private ?string $messageHookName = null;

    public function __construct () {
        $this->responseHeader = new Map();
    }

    /**
     * @return string|null
     */
    public function getHttpUrl (): ?string {
        return $this->httpUrl;
    }

    /**
     * @param string $httpUrl
     */
    public function setHttpUrl (string $httpUrl): void {
        $this->httpUrl = $httpUrl;
    }

    /**
     * @return string|null
     */
    public function getHttpMethod (): ?string {
        return $this->httpMethod;
    }

    /**
     * @param string $httpMethod
     */
    public function setHttpMethod (string $httpMethod): void {
        $this->httpMethod = $httpMethod;
    }

    /**
     * @return array
     */
    public function getHeaders (): array {
        return $this->headers;
    }

    /**
     * @param string $header
     */
    public function addHeader (string $header): void {
        $this->headers[] = $header;
    }

    /**
     * @return RpcException[]
     */
    public function getExceptions (): array {
        return $this->exceptions;
    }

    /**
     * @param RpcException $exception
     */
    public function addException (RpcException $exception): void {
        $this->exceptions[$exception->code] = $exception;
    }

    /**
     * @param string $name
     * @param string $value
     */
    public function addResponseHeader (string $name, string $value): void {
        $this->responseHeader->set($name, $value);
    }

    /**
     * @param string $name
     */
    public function addAuthority (string $name): void {
        $this->needAuthority[] = $name;
    }

    /**
     * @return string
     */
    public function getFormat (): string {
        return $this->format;
    }

    /**
     * @param string $format
     */
    public function setFormat (string $format): void {
        $this->format = $format;
    }

    /**
     * @return string
     */
    public function getMessageHookName (): string {
        return $this->messageHookName;
    }

    /**
     * @param string $messageHookName
     */
    public function setMessageHookName (string $messageHookName): void {
        $this->messageHookName = $messageHookName;
    }

    public function toArray () {
        return [
            'class'             => $this->class,
            'method'            => $this->method,
            'http_method'       => $this->httpMethod,
            'http_url'          => $this->httpUrl,
            'format'            => $this->format,
            'accept_upload'     => false, // todo AccessUpload
            'response_header'   => $this->responseHeader,
            'headers'           => $this->headers,
            'exceptions'        => $this->exceptions,
            'need_authority'    => $this->needAuthority,
            'message_hook_name' => $this->messageHookName,
        ];
    }
}