<?php

/**
 * Created by PhpStorm.
 * User: jieli
 * Date: 2023/9/7
 * Time: 下午7:27
 */

namespace Mainto\RpcServer\RpcAnnotations;

use Doctrine\Common\Annotations\Annotation\Attribute;

/**
 * Class RpcException
 * @package Mainto\RpcServer\RpcAnnotations
 *
 * @Annotation
 * @Target({"METHOD"})
 *
 * @Attributes({
 *     @Attribute("code", type = "int"),
 *     @Attribute("message", type = "string"),
 * })
 */
class RpcException {

    /**
     * 业务异常错误码
     *
     * @Required
     * @var int
     */
    public int $code;


    /**
     * 业务异常描述
     *
     * @Required
     * @var string
     */
    public string $message;

}