<?php

namespace Mainto\RpcServer\Providers;

use Mainto\RpcServer\RpcUtil\Tool\RpcMutex\CoreGearMutex;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutex\FileMutex;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutex\PbcComponentMutex;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;

class RpcMutexProvider extends \Illuminate\Support\ServiceProvider {
    public function register () {
        switch (config('rpc-server.mutex_driver')) {
            case 'gear-lock':
                $this->app->singleton(RpcMutexProviderInterface::class, function () {
                    return new CoreGearMutex();
                });
                break;
            case 'pbc-component':
                $this->app->singleton(RpcMutexProviderInterface::class, function () {
                    return new PbcComponentMutex();
                });
                break;
            default:
                $this->app->singleton(RpcMutexProviderInterface::class, function () {
                    return new FileMutex();
                });
        }
    }
}