<?php

namespace Mainto\RpcServer\Tracing\Interfaces;

interface AttributeKey {
    /**
     * http
     */
    const HTTPMethodKey = 'http.method';
    const HTTPUrlKey = 'http.url';
    const HTTPTargetKey = 'http.target';
    const HTTPHostKey = 'http.host';
    const HTTPSchemeKey = 'http.scheme';
    const HTTPHeadersKey = 'http.headers';
    const HTTPBodyKey = 'http.body';
    const HTTPStatusCodeKey = 'http.status_code';
    const HTTPFlavorKey = 'http.flavor';
    const HTTPUserAgentKey = 'http.user_agent';
    const HTTPRequestContentLengthKey = 'http.request_content_length';
    const HTTPResponseContentLengthKey = 'http.response_content_length';
    const HTTPRequestContentLengthUncompressedKey = 'http.request_content_length_uncompressed';
    const HTTPResponseContentLengthUncompressedKey = 'http.response_content_length_uncompressed';
    const HTTPServerNameKey = 'http.server_name';
    const HTTPRouteKey = 'http.route';
    const HTTPClientIPKey = 'http.client_ip';

    /**
     * rpc
     */
    const RPCVersionKey = 'rpc.version';
    const RPCMethodKey = 'rpc.method';
    const RPCRequestIDKey = 'rpc.request_id';
    const RPCErrorCodeKey = 'rpc.error_code';

    /**
     * db
     */
    const DBSystemKey = 'db.system';
    const DBConnectionStringKey = 'db.connection_string';
    const DBUserKey = 'db.user';
    const DBNameKey = 'db.name';
    const DBStatementKey = 'db.statement';
    const DBBindings = 'db.bindings';
    const DBInTransaction = 'db.in_transaction';
    const DBOperationKey = 'db.operation';
    const DBSQLTableKey = 'db.sql.table';

    const DBRedisDBIndexKey = 'db.redis.database_index';
    const DBMongoDBCollectionKey = 'db.mongodb.collection';

}