<?php

namespace Mainto\RpcServer\Tracing\Extend\Substitute;

use Illuminate\Http\Client\Factory;
use Illuminate\Http\Client\PendingRequest;
use Mainto\RpcServer\Tracing\Extend\GuzzleHttp\Middleware;

/**
 * 替换Http门面所使用的Factory
 */
class HttpFactory extends Factory {
    /**
     * Create a new pending request instance for this factory.
     *
     * @return PendingRequest
     */
    protected function newPendingRequest (): PendingRequest {
        return (new PendingRequest($this))
            ->withMiddleware(Middleware::traceMiddleware());
    }
}