<?php
namespace Mainto\RpcServer\Providers\SqlTrace;

use Illuminate\Database\Connection;
use Illuminate\Support\ServiceProvider;

class SqlTraceProvider extends ServiceProvider {
    public function boot () {
    }

    public function register () {
        Connection::resolverFor('mysql', function ($connection, $database, $prefix, $config) {
            return new MySqlConnection($connection, $database, $prefix, $config);
        });
        Connection::resolverFor('pgsql', function ($connection, $database, $prefix, $config) {
            return new PostgresConnection($connection, $database, $prefix, $config);
        });
    }
}
