<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-10-22
 * Time: 下午3:17
 */

namespace Mainto\RpcServer\Providers;

use Doctrine\Common\Annotations\AnnotationReader;
use Mainto\RpcServer\Command\RpcChildCommand;
use Mainto\RpcServer\Command\ApiDocCommand;
use Mainto\RpcServer\Command\RpcServerCommand;
use Mainto\RpcServer\Command\RpcSidecarCommand;
use Mainto\RpcServer\Providers\SqlTrace\SqlTraceProvider;
use Mainto\RpcServer\RpcServer\RpcInvoke;
use Mainto\RpcServer\RpcServer\RpcResponseHelper;
use Mainto\RpcServer\RpcServer\RpcRouter;
use Mainto\RpcServer\RpcUtil\RpcMessage;
use Mainto\RpcServer\RpcUtil\RpcMessageQueue;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;
use Mainto\RpcServer\Util\Language;
use Mainto\RpcServer\Util\ObjectMapper\JsonMapper;

class ServiceProvider extends \Illuminate\Support\ServiceProvider {
    private array $provides = [
        AutoScanProvider::class,
        RpcMutexProvider::class,
        SessionProvider::class,
        SqlTraceProvider::class,
        TracingProvider::class,
    ];

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot () {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-server.php'),
            ], 'config');
        }

        foreach ($this->provides as $class) {
            if (method_exists($class, 'boot')) {
                (new $class($this->app))->boot();
            }
        }
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-server');

        config()->set('rpc-server.environment', rpc_environment(gethostname()));
        config()->set('rpc-server.gateway_url', rpc_gateway_url(config('rpc-server.environment')));

        $this->app->bind('command.rpc.sidecar', RpcSidecarCommand::class);
        $this->app->bind('command.rpc.server', RpcServerCommand::class);
        $this->app->bind('command.rpc.child', RpcChildCommand::class);
        $this->app->bind('command.rpc.apidoc', ApiDocCommand::class);

        $this->commands([
            'command.rpc.sidecar',
            'command.rpc.server',
            'command.rpc.child',
            'command.rpc.apidoc',
        ]);

        $this->app->singleton('rpc-log', function () {
            return RpcLog::getInstance();
        });

        $this->app->singleton('rpc-server', fn() => RpcRouter::getInstance());

        // init service
        Language::init();
        RpcResponseHelper::init();

        app('events')->listen('bootstrapped: Illuminate\Foundation\Bootstrap\BootProviders', fn() => RpcInvoke::init());

        $this->app->singleton(RpcMessageQueue::class, fn() => RpcMessageQueue::getInstance());
        $this->app->singleton(RpcMessage::class, fn() => RpcMessage::getInstance());
        $this->app->singleton('json_mapper', fn() => new JsonMapper());
        $this->app->singleton(AnnotationReader::class, fn() => new AnnotationReader());

        foreach ($this->provides as $class) {
            if (method_exists($class, 'register')) {
                (new $class($this->app))->register();
            }
        }
    }
}
