<?php


namespace Mainto\RpcServer\Util\Net;


use Mainto\RpcServer\Util\Net\Listener\TcpListener;
use Mainto\RpcServer\Util\Net\Listener\UnixListener;
use RuntimeException;
use Throwable;

class Net {
    public static function dial ($network, $address): Conn {
        switch ($network) {
            case "unix":
                return Dialer::dialUnix($address);
            case "tcp":
                return Dialer::dialTcp($address);
        }

        throw new RuntimeException("not support network");
    }

    public static function dialTimeout ($network, $address, $timeout): Conn {
        $times = $timeout / 0.3;
        $i = 0;
        while (true) {
            try {
                switch ($network) {
                    case "unix":
                        return Dialer::dialUnix($address);
                    case "tcp":
                        return Dialer::dialTcp($address);
                }
            } catch (Throwable $exception) {
                if ($i++ > $times) {
                    throw $exception;
                }
                usleep(1000 * 300);
            }
        }
    }

    public static function listen($network, $address): Listener {
        switch ($network) {
            case "unix":
                return new UnixListener($address);
            case "tcp":
                return new TcpListener($address);
        }

        throw new RuntimeException("not support network");
    }
}