<?php

namespace Mainto\RpcServer\Tracing;

use Iterator;

class SpanArray implements Iterator {
    /**
     * @var int
     */
    private int $position = 0;

    /**
     * @var array
     */
    private array $spans = [];

    /**
     * @param array $spans
     */
    public function __construct (array $spans) {
        $this->spans = $spans;
    }

    /**
     * @return Span
     */
    public function current (): Span {
        return $this->spans[$this->position];
    }

    /**
     * next
     */
    public function next (): void {
        ++$this->position;
    }

    /**
     * @return int
     */
    public function key (): int {
        return $this->position;
    }

    /**
     * @return bool
     */
    public function valid (): bool {
        return isset($this->spans[$this->position]);
    }

    /**
     * 重置下标
     */
    public function rewind (): void {
        $this->position = 0;
    }

    /**
     * @return array
     */
    public function toArray (): array {
        return $this->spans;
    }
}