<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Util\Types\Map;

class NoopSpan extends Span {

    /**
     * @var NoopSpan|null
     */
    private static ?NoopSpan $_instance = null;

    /**
     * @param string $name
     * @param SpanContext|null $context
     * @param int $kind
     */
    private function __construct (string $name = '', SpanContext $context = null, int $kind = SpanKind::KIND_INTERNAL) {
        $this->tracer = Tracer::getInstance();
        $this->name = $name;
        $this->kind = $kind;
        $this->attributes = new Map();
        $this->resource = new Map();
        $this->context = $context;
    }

    /**
     * @param string $name
     * @param SpanContext|null $context
     * @param int $kind
     * @return NoopSpan
     */
    public static function getInstance (string $name, SpanContext $context, int $kind): NoopSpan {
        if (is_null(static::$_instance)) {
            static::$_instance = new static($name, $context, $kind);
        }
        static::$_instance->setName($name);
        static::$_instance->statusUnset();
        static::$_instance->setKind($kind);
        return self::$_instance;
    }

    public function end (): void {
    }

    public function addEvent (string $name, ?Map $attributes = null, int $timestamp = 0) {
    }

    public function appendEvent (Event $event) {
    }

    public function setAttribute (string $key, string $value): self {
        return $this;
    }

    public function setResource (string $key, string $value): self {
        return $this;
    }

    public function setLink (Span $span): self {
        return $this;
    }

    public function setSampled (bool $sampled): self {
        return $this;
    }
}
