<?php
/**
 * Created by PhpStorm.
 * User: PHPStorm
 * Date: 18-12-12
 * Time: 下午2:22
 */

namespace Mainto\RpcServer\RpcUtil\SessionHandler;

use Mainto\RpcServer\RpcServer\RpcSessionHandlerInterface;

class SessionTestHandler implements RpcSessionHandlerInterface {
    /**
     * The session attributes.
     *
     * @var string|null
     */
    protected static ?string $attributes = null;

    /**
     * 设置 session 内容
     * @param array $sessionContent
     */
    public static function setSession (array $sessionContent): void {
        $sessionContent['expired_at'] = time() + 3600;

        static::$attributes = json_encode(json_encode($sessionContent));
    }

    /**
     * 获取 session 内容
     * @return array|null
     */
    public static function getSession (): ?array {
        if (static::$attributes === null) {
            return null;
        }

        $data = json_decode(json_decode(static::$attributes, true), true);

        unset($data['expired_at']);

        return $data ?? [];
    }

    /**
     * 清空 session 内容
     */
    public static function clearSession (): void {
        static::$attributes = null;
    }

    /**
     * 根据 sessionId 获取 session 序列化字符串
     * @param $sessionId
     * @return string|null
     */
    public function getSessionStringBySessionId ($sessionId): ?string {
        return static::$attributes;
    }

    /**
     * 更新 session
     * @param $sessionId
     * @param $sessionString
     * @param $seconds
     */
    public function updateSession ($sessionId, $sessionString, $seconds): void {
        static::$attributes = $sessionString;
    }

    /**
     * 删除 session
     * @param $sessionId
     */
    public function deleteSession ($sessionId): void {
        static::clearSession();
    }
}