<?php


namespace Mainto\RpcServer\RpcServer\Middleware\Kernel;


use Closure;
use Illuminate\Support\Facades\Log;
use Mainto\RpcServer\Log\LogHandler;
use Mainto\RpcServer\Protocol\Response\Response;
use Mainto\RpcServer\RpcServer\Middleware\KernelMiddleware;
use Mainto\RpcServer\RpcServer\RpcStreamContext;

class DumpKernelMiddleware implements KernelMiddleware {

    /**
     * @param RpcStreamContext $context
     * @param Closure $next
     * @return Response
     */
    public function handle (RpcStreamContext $context, Closure $next): Response {
        Log::debug("server recv req", ['pid' => $context->pid, 'traceId' => $context->request->getTraceId(), 'data' => $context->request->logData()]);

        $response = $next($context);

        Log::debug("server send req", ['pid' => $context->pid, 'traceId' => $context->request->getTraceId(), 'data' => $response->toArray()]);

        return $response;
    }
}