<?php


namespace Mainto\RpcServer\RpcServer\Definition;


use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\RpcServer\Definition\Traits\ValidateGetter;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\ObjectMapper\PropertiesInterface;

class Struct implements Arrayable, PropertiesInterface {
    use ArrayHelper, ValidateGetter;

    public string $name;
    public string $namespace;
    public string $from = "object";

    /**
     * @var Property[]
     */
    public array $properties = [];

    public function getProperties (): array {
        return $this->properties;
    }

    public function fullName(): string {
        return $this->namespace . '\\'. $this->name;
    }
}