<?php


namespace Mainto\RpcServer\RpcServer\Definition;

use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

/**
 * Class Controller
 * @package Mainto\RpcServer\RpcServer\Definition
 */
class Controller implements Arrayable {
    use ArrayHelper;

    /**
     * @var string $name
     */
    public string $name;

    /**
     * @var string $alias
     */
    public string $alias = "";

    /**
     * @var string $registerName
     */
    public string $registerName;

    /**
     * @var Map<Method>|Method[]
     */
    public Map $methods;

    /**
     * @var object|null
     */
    private ?object $instance = null;

    /**
     * @var string|null
     */
    private ?string $abstract;

    public function __construct (string $abstract = null) {
        $this->abstract = $abstract;
        $this->methods = new Map();
    }

    /**
     * @return object
     */
    public function getInstance (): ?object {
        if ($this->instance == null) {
            $this->instance = app($this->abstract);
        }

        return $this->instance;
    }
}