<?php


namespace Mainto\RpcServer\RpcServer\Middleware\Method;


use Closure;
use Illuminate\Database\MySqlConnection;
use Illuminate\Support\Facades\DB;
use Mainto\RpcServer\RpcServer\Middleware\MethodMiddleware;
use Mainto\RpcServer\RpcServer\RpcContext;

class RecoverMiddleware implements MethodMiddleware {
    private static ?RecoverMiddleware $instance = null;

    private function __construct () { }

    public static function getInstance (): ?RecoverMiddleware {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function handle (RpcContext $context, Closure $next, $args = []) {
        try {
            return $next($context);
        } finally {
            $this->resourceRecover();
        }
    }

    /**
     * 回收可能导致有问题的资源
     */
    private function resourceRecover () {
        foreach (DB::getConnections() as $connection) {
            if ($connection instanceof MySqlConnection) {
                while ($connection->transactionLevel()) {
                    $connection->rollBack();
                }
            }
        }
    }
}