<?php

namespace Mainto\RpcServer\Tracing\Support\Aliyun;

use Mainto\RpcServer\RpcUtil\Tool\RpcLog;
use Mainto\RpcServer\Tracing\Interfaces;
use Mainto\RpcServer\Tracing\Source;
use Mainto\RpcServer\Tracing\Span;
use Mainto\RpcServer\Tracing\SpanArray;

/**
 * 上报器
 */
class Exporter implements Interfaces\Exporter {
    /**
     * @var Converter
     */
    private Converter $converter;

    /**
     * 实例化
     */
    public function __construct () {
        $this->converter = new Converter();
    }

    /**
     * @param array|Span[] $spans
     * @param Source $source
     */
    public function export (array $spans, Source $source): void {
        // 遍历循环
        foreach ($spans as $span) {
            $this->exportSpan($span, $source);
        }
    }

    /**
     * @param Span $span
     * @param Source $source
     */
    public function exportSpan (Span $span, Source $source): void {
        // 转换span数据为阿里云链路格式
        $convertSpan = $this->converter->convert($span, $source);
        // 提交
        RpcLog::getInstance()->tracer(new SpanArray($convertSpan));
    }
}
