<?php

namespace Mainto\RpcServer\RpcServer;

use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\ContextTrait\HeaderTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\ParamTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RequestTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\RpcMessageTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\SessionTrait;
use Mainto\RpcServer\RpcServer\ContextTrait\UrlTrait;
use Mainto\RpcServer\Util\IO\Reader;

class RpcContext {
    use ParamTrait;
    use HeaderTrait;
    use SessionTrait;
    use RpcMessageTrait;
    use RequestTrait;
    use UrlTrait;

    /**
     * @deprecated
     * @var string
     */
    public static string $currentTraceId = "";

    private ?Body $body = null;

    public function __construct (Request $request) {
        $this->request = $request;
        $this->rpcParams = new RpcParams();
        $this->resetParams();
    }

    public function getTraceId (): string {
        return $this->request->getTraceId();
    }

    /**
     * @return string
     */
    public function getRequestFrom (): string {
        return $this->getRequestHeaders()['X-Request-From'] ?? 'unknown';
    }

    public function addResponseStreamBody(int $bodySize, Reader $read) {
        $this->body = Body::newStreamBody($bodySize, $read);
    }

    public function getBody(): ?Body {
        return $this->body;
    }
}