<?php


namespace Mainto\RpcServer\Service\Struct;


use Mainto\RpcServer\Exceptions\RpcRuntimeException;

trait BaseStruct {
    /**
     * @var string
     */
    private string $class = "";
    /**
     * @var string
     */
    private string $method = "";


    public function setClass (string $className) {
        if (strlen($className) > 255) {
            throw new RpcRuntimeException(sprintf("class name [%s] length must be less than 255", $className));
        }

        $this->class = $className;
    }

    public function setMethod (string $methodName) {
        if (strlen($methodName) > 255) {
            throw new RpcRuntimeException(sprintf("method name [%s] length must be less than 255", $methodName));
        }

        $this->method = $methodName;
    }

    /**
     * @return string
     */
    public function getClass (): string {
        return $this->class;
    }

    /**
     * @return string
     */
    public function getMethod (): string {
        return $this->method;
    }
}