<?php

namespace Mainto\RpcServer\RpcServer\Middleware\Method;

use Closure;
use Illuminate\Support\Str;
use Mainto\RpcServer\RpcServer\Middleware\MethodMiddleware;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

class ArrayMapCheckMiddleware implements MethodMiddleware {

    public function handle (RpcContext $context, Closure $next, $args = []) {
        $res = $next($context);
        if ($context->getMethod()->responseType == 'array' || Str::endsWith($context->getMethod()->responseType, [])) {
            if ($this->isAssoc($res)) {
                RpcLog::getInstance()->warning("result need array but is assoc", [
                    "result" => $res,
                ]);
            }
        }

        return $res;
    }

    public function isAssoc ($array): bool {
        foreach (array_keys($array) as $k => $v) {
            if ($k !== $v) {
                return true;
            }
        }
        return false;
    }

    private static ?ArrayMapCheckMiddleware $instance = null;

    private function __construct () {
    }

    public static function getInstance (): ?ArrayMapCheckMiddleware {
        if (self::$instance === null) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}