<?php

namespace Mainto\RpcServer\Util\Reader;

use Generator;
use Mainto\RpcServer\Util\Bytes\Buffer;
use Mainto\RpcServer\Util\IO\Exceptions\ClosedPipeException;
use Mainto\RpcServer\Util\IO\Reader;

class GeneratorReader implements Reader {

    private Generator $generator;

    private bool $closed = false;

    private Buffer $buffer;

    public function __construct (Generator $generator) {
        $this->generator = $generator;

        $this->buffer = new Buffer();
    }

    public function read (int $size): ?string {
        if ($this->closed) {
            throw new ClosedPipeException();
        }

        $data = $this->buffer->read($size);
        if ($data == null || strlen($data) < $size) {
            $this->buffer->reset();
            if ($this->next()) {
                return $data ? $data . $this->read($size - strlen($data)) : $this->read($size);
            } else {
                $this->closed = true;
                return $data;
            }
        } else {
            return $data;
        }
    }

    private function next(): bool {
        if ($this->generator->valid()) {
            $this->buffer->write($this->generator->current());
            $this->generator->next();
            return true;
        } else {
            return false;
        }
    }
}
