<?php


namespace Mainto\RpcServer\Base;


use Exception;
use Ramsey\Uuid\Uuid;
use Ramsey\Uuid\UuidInterface;
use RuntimeException;

/**
 * Class RpcMessage
 * @package Mainto\RpcServer\Base
 */
abstract class RpcMessage {
    public string $_uuid_;
    private array $formatValue;

    /**
     * @param array $formatValue
     */
    public function __construct (array $formatValue = []) {
        $this->_uuid_ = $this->mustGetUuid4()->toString();
        $this->formatValue = $formatValue;
    }

    /**
     * 不能包含字符 ' " < > & : |
     *
     * @return string
     */
    abstract public static function messageName (): string;

    private function mustGetUuid4 (): UuidInterface {
        try {
            return Uuid::uuid4();
        } catch (Exception $e) {
            throw new RuntimeException($e->getCode(), $e->getMessage());
        }
    }

    public function formatValue (): array {
        return $this->formatValue;
    }
}