<?php

namespace Mainto\RpcServer\Util\Reader;

use Mainto\RpcServer\Util\IO\ReadCloser;

class FileReader implements ReadCloser {

    /**
     * @var resource
     */
    private $resource;

    public function __construct ($resource) {
        if (!is_resource($resource)) {
            throw new \RuntimeException("file reader need resource");
        }


        $this->resource = $resource;
    }

    public function close () {
        fclose($this->resource);
    }

    public function read (int $size): ?string {
        return fread($this->resource, 102400);
    }
}