<?php


namespace Mainto\RpcServer\RpcServer;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Arr;
use Mainto\RpcServer\Util\Language;

/**
 * Class RpcParams
 * @package Mainto\RpcServer\Server
 */
class RpcParams implements Arrayable {
    public array $_declareNames = [];

    public ?array $params = null;

    private ?array $onlyDeclare = null;

    /**
     * 获得声明中的参数
     */
    public function onlyDeclare (): array {
        if ($this->onlyDeclare === null) {
            $this->onlyDeclare = [];

            foreach ($this->_declareNames as $name) {
                $get = data_get($this->params, $name, Language::$placeholder);
                if ($get !== Language::$placeholder) {
                    Arr::set($this->onlyDeclare, $name, $get);
                }
            }
        }

        return $this->onlyDeclare;
    }

    public function __construct ($params = []) {
        $this->params = $params;
    }

    public function only ($params = []): array {
        return Arr::only($this->params, $params);
    }

    public function get ($key, $default = null) {
        return Arr::get($this->params, $key, $default);
    }

    public function set ($key, $value) {
        return Arr::set($this->params, $key, $value);
    }

    public function except ($keys): array {
        return Arr::except($this->params, $keys);
    }

    public function declaredExcept($keys): array {
        return Arr::except($this->onlyDeclare(), $keys);
    }

    public function has ($key): bool {
        return Arr::has($this->params, $key);
    }

    public function toArray(): array {
        return $this->params;
    }
}