<?php


namespace Mainto\RpcServer\RpcServer\Definition;

use Illuminate\Contracts\Support\Arrayable;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

/**
 * Class Controller
 * @package Mainto\RpcServer\RpcServer\Definition
 */
class Controller implements Arrayable {
    use ArrayHelper;

    /**
     * @var string $name
     */
    public string $name;

    /**
     * @var string $alias
     */
    public string $alias = "";

    /**
     * @var string $registerName
     */
    public string $registerName;

    /**
     * @var string
     */
    public string $namespace;

    /**
     * @var Map<Method>|Method[]
     */
    public Map $methods;

    /**
     * @var object|null
     */
    private ?object $instance;

    public function __construct (object $instance = null) {
        $this->instance = $instance;
        $this->methods = new Map();
    }

    /**
     * @return object
     */
    public function getInstance (): ?object {
        return $this->instance;
    }
}