<?php


namespace Mainto\RpcServer\Providers;


use Mainto\RpcServer\Exceptions\RpcLockException;
use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcUtil\Tool\RpcMutexProviderInterface;

class RpcMutexProvider extends \Illuminate\Support\ServiceProvider {
    public function register () {
        if (config('rpc-server.mutex_driver') == 'gear-lock') {
            $this->app->singleton(RpcMutexProviderInterface::class, function () {
                return new class implements RpcMutexProviderInterface {
                    private static function getLockCli () {
                        return RpcClass::getClass("CoreGear", "Lock");
                    }

                    public static function getLock (string $lockName, int $expireTime = 600) {
                        return self::getLockCli()->getLock([
                            "lockName"   => $lockName,
                            "expireTime" => $expireTime,
                        ]);
                    }

                    public static function unLock (string $lockName, string $password): bool {
                        return self::getLockCli()->unlock([
                            "lockName" => $lockName,
                            "password" => $password,
                        ]);
                    }
                };
            });
        } else {
            $this->app->singleton(RpcMutexProviderInterface::class, function () {
                return new class implements RpcMutexProviderInterface {
                    public static array $locks = [];

                    public static function getLock (string $lockName, int $expireTime = 600) {
                        if (isset(self::$locks[$lockName])) {
                            throw new RpcLockException("{$lockName} lock fail, try it later", 0xF0106801);
                        } else {
                            $fp = fopen('/tmp/mtrpc_mutex_'.$lockName, 'w+');
                            if (!flock($fp, LOCK_EX)) {
                                throw new RpcLockException("{$lockName} lock fail, try it later", 0xF0106801);
                            }
                            $password = rand(100000000000, 9999999999999999);
                            fwrite($fp, $password);
                            self::$locks[$lockName] = $fp;
                            return $password;
                        }
                    }

                    public static function unLock (string $lockName, string $password): bool {
                        if (!isset(self::$locks[$lockName])) {
                            return false;
                        }
                        $fp = self::$locks[$lockName];

                        fseek($fp, 0);
                        if (fread($fp, 1000) === $password) {
                            flock($fp, LOCK_UN);
                            fclose($fp);
                            unlink('/tmp/mtrpc_mutex_'.$lockName);
                            return true;
                        }

                        return false;
                    }
                };
            });
        }
    }
}