<?php

namespace Mainto\RpcServer\Tracing\Traits;

use Mainto\RpcServer\Tracing\Event;
use Mainto\RpcServer\Util\Types\Map;

trait Events {
    /**
     * @var array
     */
    protected array $events = [];

    /**
     * @param string $name
     * @param Map|null $attributes
     * @param float $timestamp
     */
    public function addEvent (string $name, ?Map $attributes = null, float $timestamp = 0) {
        array_push($this->events, new Event($name, $timestamp, $attributes));
    }

    /**
     * @param Event $event
     */
    public function appendEvent (Event $event) {
        array_push($this->events, $event);
    }

    /**
     * @return array|Event[]
     */
    public function getEvents (): array {
        return $this->events;
    }
}
