<?php

namespace Mainto\RpcServer\Tracing;

class Context {
    const TRACE_PARENT_HEADER = 'traceParent';
    const SUPPORTED_VERSION = 0;
    const MAX_VERSION = 254;

    /**
     * @var SpanContext|null $spanContext
     */
    private static ?SpanContext $spanContext;

    /**
     * @return string
     */
    public static function getHeaderValue (): string {
        // tracer
        $tracer = Tracer::getInstance();
        // 返回
        return sprintf(
            "%02d-%s-%s-%02d",
            number_format(static::SUPPORTED_VERSION, 2),
            self::getSpanContext()->getTraceId(),
            self::getSpanContext()->getSpanId(),
            $tracer->isSampled() ? 0x01 : 0x00,
        );
    }

    /**
     * @param string $traceId
     * @param string $headerValue
     *
     * @return Tracer
     */
    public static function extract (string $traceId, string $headerValue): Tracer {
        // tracer
        $tracer = Tracer::getInstance();
        // 判断是否为空
        if (!empty($headerValue)) {
            [$version, $traceId, $spanId, $sampled] = explode('-', $headerValue, 4);
            $sampled = is_numeric($sampled) ? (int)$sampled : 0;
            $tracer->setSampled((bool)$sampled);
            self::setSpanContext(new SpanContext($traceId, $spanId));
        } else {
            $tracer->setSampled(false);
            self::setSpanContext(new SpanContext($traceId, ''));
        }
        // 存储traceId
        $tracer->setTraceId($traceId);

        return $tracer;
    }

    /**
     * @return SpanContext
     */
    public static function getSpanContext (): SpanContext {
        return self::$spanContext ?? SpanContext::emptyContext();
    }

    /**
     * @param SpanContext|null $spanContext
     */
    public static function setSpanContext (?SpanContext $spanContext): void {
        self::$spanContext = $spanContext;
    }

    /**
     * @return Span|null
     */
    public static function currentSpan (): ?Span {
        return self::getSpanContext()->getSpan();
    }
}