<?php

namespace Mainto\RpcServer\Providers;

use Illuminate\Cache\Events\CacheHit;
use Illuminate\Cache\Events\CacheMissed;
use Illuminate\Cache\Events\KeyWritten;
use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Redis\Events\CommandExecuted;
use Illuminate\Support\Facades\Event;
use Mainto\RpcServer\Tracing\Listeners\CacheHitListener;
use Mainto\RpcServer\Tracing\Listeners\CacheMissedListener;
use Mainto\RpcServer\Tracing\Listeners\DatabaseQueryListener;
use Mainto\RpcServer\Tracing\Listeners\KeyWrittenListener;

class EventServiceProvider extends ServiceProvider {
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        QueryExecuted::class => DatabaseQueryListener::class,
        CacheHit::class => CacheHitListener::class,
        CacheMissed::class => CacheMissedListener::class,
        KeyWritten::class => KeyWrittenListener::class,
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot () {
        foreach ($this->listen as $event => $listener) {
            Event::listen($event, $listener,);
        }
    }
}
