<?php

namespace Mainto\RpcServer\Providers;

use Illuminate\Database\Events\QueryExecuted;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Redis\Events\CommandExecuted;
use Mainto\RpcServer\Listeners\RedisCommandExecuted;
use Mainto\RpcServer\Listeners\DatabaseQueryExecuted;

class EventServiceProvider extends ServiceProvider {
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        QueryExecuted::class   => [
            DatabaseQueryExecuted::class,
        ],
        CommandExecuted::class => [
            RedisCommandExecuted::class,
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot () {
        //
    }
}
