<?php

namespace Mainto\RpcServer\Tracing\Traits;

trait Timer
{

    /**
     * @var int
     */
    private int $nanosecond = 1000000; // 1e6

    /**
     * @var int
     */
    protected int $start;

    /**
     * @var int
     */
    protected int $end;

    /**
     * @var int
     */
    protected int $duration;

    /**
     * @return int
     */
    public function getStart(): int
    {
        return $this->start;
    }

    /**
     * @return int
     */
    public function getEnd(): int
    {
        return $this->end;
    }

    /**
     * @return int
     */
    public function getDuration(): int
    {
        if ($this->isRecording()) {
            $this->end();
        }

        return $this->duration;
    }

    /**
     * @param int $time
     */
    public function end(int $time = 0): void
    {
        // 判断是否为空
        if (empty($time) && !empty($this->end)) {
            return;
        }
        $this->end = $time ?: microtime(true) * $this->nanosecond;
        $this->duration = $this->end - $this->start;
    }

    /**
     * @return bool
     */
    public function isRecording(): bool
    {
        return null === $this->end;
    }
}
