<?php

namespace Mainto\RpcServer\Tracing;

use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Traits\Attributes;
use Mainto\RpcServer\Tracing\Traits\Links;
use Mainto\RpcServer\Tracing\Traits\Events;
use Mainto\RpcServer\Tracing\Traits\Resource;
use Mainto\RpcServer\Tracing\Traits\Sampled;
use Mainto\RpcServer\Tracing\Traits\Status;
use Mainto\RpcServer\Tracing\Traits\Timer;

class Span
{
    use Attributes, Links, Events, Resource, Timer, Status, Sampled;

    /**
     * @var string
     */
    protected string $name;

    /**
     * @var int
     */
    protected int $kind;

    /**
     * @var string
     */
    protected string $spanId;

    /**
     * @var string
     */
    protected string $traceId;

    /**
     * @var string
     */
    protected string $parentSpanId;

    /**
     * @param string $name
     * @param int $kind
     */
    public function __construct(string $name = '', int $kind = SpanKind::KIND_SERVER)
    {
        $tracer = Tracer::getInstance();

        $this->traceId = $tracer->getTraceId();
        $this->spanId = $tracer->getIdGenerator()->generateSpanId();
        $this->start = microtime(true) * $this->nanosecond;
        $this->name = $name;
        $this->parentSpanId = $tracer->getCurrentSpanId();
        $this->kind = $kind;
        $this->sampled = true;
        $this->statusUnset();

        // 存入span
        $tracer->appendSpan($this);
    }

    /**
     * @param string $name
     * @return Span
     */
    public static function start(string $name): Span
    {
        return new Span($name);
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getKind(): int
    {
        return $this->kind;
    }

    /**
     * @return string
     */
    public function getSpanId(): string
    {
        return $this->spanId;
    }

    /**
     * @return string
     */
    public function getTraceId(): string
    {
        return $this->traceId;
    }

    /**
     * @return string
     */
    public function getParentId(): string
    {
        return $this->parentSpanId;
    }
}
