<?php

namespace Mainto\RpcServer\Tracing;

class IdGenerator
{
    private const TRACE_ID_HEX_LENGTH = 32;
    private const SPAN_ID_HEX_LENGTH = 16;

    /**
     * @return string
     */
    public function generateTraceId(): string
    {
        return $this->randomHex(self::TRACE_ID_HEX_LENGTH);
    }

    /**
     * @return string
     */
    public function generateSpanId(): string
    {
        return $this->randomHex(self::SPAN_ID_HEX_LENGTH);
    }

    /**
     * @param int $hexLength
     * @return string
     */
    public function randomHex(int $hexLength): string
    {
        try {
            return bin2hex(random_bytes(intdiv($hexLength, 2)));
        } catch (\Throwable $e) {
            return $this->fallbackAlgorithm($hexLength);
        }
    }

    /**
     * @param int $hexLength
     * @return string
     */
    private function fallbackAlgorithm(int $hexLength): string
    {
        return substr(str_shuffle(str_repeat('0123456789abcdef', $hexLength)), 1, $hexLength);
    }
}
